*-------------------------------------------------------------------------------
*						Fig 5c
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out" 

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Fig 5c", replace 
set more off     

**----------------------------------------------------------------------------**
* Step1: Generate Data
**----------------------------------------------------------------------------**
clear
clear all

//empty file for processed data
set obs 0
save plotdata,replace emptyok

//pop_{o,j,t}
foreach j in "2000" "2010" "2015"{
use "`j'census_consistent.dta",clear
keep age index*
gen id_new=_n

gen period=`j'
append using plotdata
save plotdata,replace
}

**----------------------------------------------------------------------------**
* Step2: Estimation
**Reference: 
*https://yangclaireyang.web.unc.edu ...
*... /age-period-cohort-analysis-new-models-methods-and-empirical-applications ...
*... /chapter-5/
**----------------------------------------------------------------------------**
use plotdata,clear

*Prepare PCA standard data
foreach num of numlist 15(5)65{
local age_`num' = `num'
}
egen age_group = cut(age), at(`age_15' `age_20' `age_25' `age_30' `age_35' `age_40' `age_45' `age_50' `age_55' `age_60' `age_65')

gen cohort = period-age_group
collapse (mean) index* ,by(age_group period cohort)

rename (index1_competition index2_interact index3_cognitive index4_physical index5_routinemanual index6_routinecognitive) (competition interact cognitive physical routinemanual routinecognitive)


foreach var of varlist competition-routinecognitive{

gen b_age`var'=.
gen b_cohort`var'=.
gen b_period`var'=.

apc_ie `var', age(age_group) period(period) cohort(cohort) 

forvalues a = 15(5)60{
replace b_age`var'=_b[age_`a'] if age_group==`a'
}

foreach p in "2000" "2010" "2015"{
replace b_period`var'=_b[period_`p'] if period==`p'
}

forvalues c = 1940(5)1995 {
replace b_cohort`var'=_b[cohort_`c'] if cohort==`c'
}
}

keep b_* cohort age_group period
reshape long b_age b_cohort b_period,i(period age_group cohort) j(index) string

//Age-Profile
preserve
keep age_group b_age index
duplicates drop
rename (b_age age_group) (coef age)
twoway (connected coef age if index=="cognitive",sort lp(solid) lc(black) mcolor(black) msize(vsmall) msymbol(S)) ///
(connected coef age if index=="physical",sort lp(solid) lc(red) mcolor(red) msize(vsmall) msymbol(S)) ///
(connected coef age if index=="routinecognitive",sort lp(dash) lc(black) mcolor(black) msize(vsmall) msymbol(T)) ///
(connected coef age if index=="routinemanual",sort lp(dash) lc(red) mcolor(red) msize(vsmall) msymbol(T)) ///
(connected coef age if index=="competition",sort lp(shortdash) lc(black) mcolor(black) msize(vsmall) msymbol(O)) ///
(connected coef age if index=="interact",sort lp(longdash) lc(black) mcolor(black) msize(vsmall) msymbol(D)) ///
,ytitle("年龄效应") xtitle("年龄段") ylabel(-0.5(0.1)0.4,nogrid)  scheme(plotplain) ///
xlabel(15 "15-19" 20 "20-24" 25 "25-29" 30 "30-34" 35 "35-39" 40 "40-44" 45 "45-49" 50 "50-54" 55 "55-59" 60 "60-64", angle(45) nogrid) ///
legend(label(1 "认知能力") label(2 "体力能力") label(3 "重复性认知") label(4 "重复性体力") label(5 "竞争要求") label(6 "协同要求") rows(2) position(6)) ///
yline(0) xsize(4) ysize(6)
graph save "$Out_lab\Fig5c",replace
graph export "$Out_lab\Fig5c.png",replace
restore

/*
//Cohort-Profile
preserve
keep cohort b_cohort index
duplicates drop 
rename b_cohort coef
drop if cohort==2000 //2000 lack of obs to esitmate
twoway (connected coef cohort if index=="cognitive",sort lp(solid) lc(black) mcolor(black) msize(small) msymbol(S)) ///
(connected coef cohort if index=="physical",sort lp(solid) lc(red) mcolor(red) msize(small) msymbol(S)) ///
(connected coef cohort if index=="routinecognitive",sort lp(dash) lc(black) mcolor(black) msize(small) msymbol(T)) ///
(connected coef cohort if index=="routinemanual",sort lp(dash) lc(red) mcolor(red) msize(small) msymbol(T)) ///
(connected coef cohort if index=="competition",sort lp(shortdash) lc(black) mcolor(black) msize(small) msymbol(O)) ///
(connected coef cohort if index=="interact",sort lp(longdash) lc(black) mcolor(black) msize(small) msymbol(D)) ///
,ytitle("队列效应") xtitle("出生年代") ylabel(-0.5(0.1)0.5,nogrid)  scheme(plotplain) ///
xlabel(1940 "1936-1940" 1945 "1941-1945" 1950 "1946-1950" 1955 "1951-1955" 1960 "1956-1960" 1965 "1961-1965" 1970 "1966-1970" 1975 "1971-1975" 1980 "1976-1980" 1985 "1981-1985" 1990 "1986-1990" 1995 "1991-1995", angle(45) nogrid) ///
legend(label(1 "认知能力") label(2 "体力能力") label(3 "重复性认知") label(4 "重复性体力") label(5 "竞争要求") label(6 "协同要求") rows(1) position(6)) yline(0)
graph save "$Out_lab\appendix_Fig12a",replace
graph export "$Out_lab\appendix_Fig12a.png",replace
restore

//Period-Profile
preserve
keep period b_period index
duplicates drop 
rename b_period coef
twoway (connected coef period if index=="cognitive",sort lp(solid) lc(black) mcolor(black) msize(small) msymbol(S)) ///
(connected coef period if index=="physical",sort lp(solid) lc(red) mcolor(red) msize(small) msymbol(S)) ///
(connected coef period if index=="routinecognitive",sort lp(dash) lc(black) mcolor(black) msize(small) msymbol(T)) ///
(connected coef period if index=="routinemanual",sort lp(dash) lc(red) mcolor(red) msize(small) msymbol(T)) ///
(connected coef period if index=="competition",sort lp(shortdash) lc(black) mcolor(black) msize(small) msymbol(O)) ///
(connected coef period if index=="interact",sort lp(longdash) lc(black) mcolor(black) msize(small) msymbol(D)) ///
,ytitle("时期效应") xtitle("时期") ylabel(-0.5(0.1)0.5,nogrid)  scheme(plotplain) ///
xlabel(2000(5)2015, angle(45) nogrid) ///
legend(label(1 "认知能力") label(2 "体力能力") label(3 "重复性认知") label(4 "重复性体力") label(5 "竞争要求") label(6 "协同要求") rows(1) position(6)) yline(0)
graph save "$Out_lab\appendix_Fig12b",replace
graph export "$Out_lab\appendix_Fig12b.png",replace
restore

*/

erase plotdata.dta 
log close

